﻿using AP_8_Adressage_IP_Alexis_Alagille;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static System.Windows.Forms.VisualStyles.VisualStyleElement.ToolTip;

namespace AP_8_Adressage_IP_Alexis_Alagille
{
    public partial class Traitements : Form
    {
        public Traitements()
        {
            InitializeComponent();
        }


        // Fonction Conversion Binaire --> Décimal //
        public string Conversion_Bin_Dec(string[] binaire_parts, string[] parts, byte nb_Base)
        {
            string resultat = "";
            for (int i = 0; i < 4; i++)
            {
                byte parts_convert = Convert.ToByte(binaire_parts[i], nb_Base);
                parts[i] = parts_convert.ToString();
                resultat = String.Join(".", parts);
            }
            return resultat;
        }

        // Fonction Calcul nombre de sous-réseaux //
        string Sous_reseaux(byte masque_defaut)
        {
            string nb_sous_reseaux;

            // Sous réseaux //
            if (Global.cidr > masque_defaut)
            {
                nb_sous_reseaux = Math.Pow(2, Global.cidr - masque_defaut).ToString();
            }
            // Si CIDR < masque par défaut : on a un super-réseaux donc 1 sous réseau //
            else
            {
                nb_sous_reseaux = "1";
            }
            return nb_sous_reseaux;
        }


        // Cette fenètre est principalement présente pour de l'affichage avec des calculs donc tout se fait au chargement //
        private void Traitements_Load(object sender, EventArgs e)
        {
            int cidr = Global.cidr;
            string masque, masque_binaire;

            tb_ip.Text = Global.ip;
            tb_cidr.Text = (Global.cidr).ToString();

            // Conversion CIDR en Masque Binaire //

            string[] masque_binaire_parts = { "", "", "", "" };
            for (int i = 0; i < 4; i++)
            {
                while (masque_binaire_parts[i].Length != 8)
                {
                    if (cidr != 0)
                    {
                        masque_binaire_parts[i] += "1";
                        cidr -= 1;
                    }
                    else
                    {
                        masque_binaire_parts[i] += "0";
                    }
                }

                masque_binaire = String.Join(".", masque_binaire_parts);
                tb_masque_binaire.Text = masque_binaire;

            }

            // Conversion Masque Binaire en Masque //
            
            string[] masque_parts = { "", "", "", "" };

            masque = Conversion_Bin_Dec(masque_binaire_parts, masque_parts, 2);
            tb_masque.Text = masque;


            // Et Logique Calcul Adresse Réseaux //
            string[] adresse_reseau_binaire = {"", "", "", ""};
            string[] ip_binaire_part = Global.ip_binaire.Split(".");
           
            string adresse_reseau = "";

            for (int i = 0; i < 4; i++)
            {
                for (int j = 0; j < 8; j++)
                {   // Attention ! : ip_binaire_part est un char donc on doit utiliser des ' ' pour le char et non pas des " " //
                    if (ip_binaire_part[i][j] == '1' && masque_binaire_parts[i][j] == '1')
                    {
                        adresse_reseau_binaire[i] += "1";
                    }
                    else
                    {
                        adresse_reseau_binaire[i] += "0";
                    }
                }
            }

            string[] adresse_reseau_parts = { "", "", "", "" };
            adresse_reseau = Conversion_Bin_Dec(adresse_reseau_binaire, adresse_reseau_parts, 2);

            tb_adresse_réseau.Text = adresse_reseau;



            // Calcul du nombre d'Hote
            byte nb_0 = (byte)(32 - Global.cidr);

            // En C# on utilise Math.Pow(nombre, puissance) pour calculer une puissance //
            // (int) pour forcer la conversion en int puisque Math.Pow renvoi un double //
            uint nb_hotes = (uint)Math.Pow(2, nb_0) - 2;

            if (nb_0 == 0)
            {
                tb_hotes.Text = "0";
            }
            else if (nb_hotes > 0)
            {
                tb_hotes.Text = nb_hotes.ToString();
            }
            else
            {
                tb_hotes.Text = "0";
            }

            // Classe adresse IP +  Calcul du nombre de sous-réseaux //

            int octet_verif = Convert.ToByte(ip_binaire_part[0], 2);
            if (octet_verif >= 1 && octet_verif <= 126)
            {
                Global.classe = "A";
                tb_nb_ss_reseaux.Text = Sous_reseaux(8);
            }
            else if (octet_verif >= 128 && octet_verif <= 191)
            {
                Global.classe = "B";
                tb_nb_ss_reseaux.Text = Sous_reseaux(16);
            }
            else if (octet_verif >= 192 && octet_verif <= 223)
            {
                Global.classe = "C";
                tb_nb_ss_reseaux.Text = Sous_reseaux(24);
            }
            else if (octet_verif >= 224 && octet_verif <= 239)
            {
                Global.classe = "D";
                tb_nb_ss_reseaux.Text = "0";
            }
            else
            {
                Global.classe = "E";
                tb_nb_ss_reseaux.Text = "0";
            }
            tb_classe.Text = Global.classe;
        }

        private void btn_quit_Click_1(object sender, EventArgs e)
        {
            this.Close();
        }

        // Calcul du nouveau CIDR selon la saisie de l'utilisateur //
        private void btn_calcul_nv_cidr_Click(object sender, EventArgs e)
        {
            int nb_ss_reseaux_souhait = int.Parse(nUP_nb_ss_res_dem.Text);
            int nv_cidr = 0;
            bool nv_cidr_trouve = false;
            int i = 0;
            
            while (nv_cidr_trouve == false)
            {
                // res_temp = variable temporaire pour tester le calcul //
                int res_temp = 0;
                int masque_defaut = 0;
                if (Global.classe == "A")
                {
                    masque_defaut = 8;
                }
                else if(Global.classe == "B")
                {
                    masque_defaut = 16;
                }
                else if (Global.classe == "C")
                {
                    masque_defaut = 24;
                }

                // On détermine le nouveau CIDR selon i qu'on incrémente à chaque tour de la boucle While //
                res_temp = (int)Math.Pow(2, i - masque_defaut);
                if (res_temp >= nb_ss_reseaux_souhait)
                {
                    nv_cidr = i;
                    nv_cidr_trouve = true;
                    tb_nv_cidr.Text = (nv_cidr).ToString();
                }
                else
                {
                    i++;
                }  
            }
        }
    }
}



